"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const moment_1 = tslib_1.__importDefault(require("moment"));
const react_2 = tslib_1.__importDefault(require("react"));
exports.StatusBar = ({ timestamp, host, port, duration, scheme, status }) => (react_2.default.createElement(eui_1.EuiPanel, null,
    react_2.default.createElement(eui_1.EuiFlexGroup, { gutterSize: "l" },
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(eui_1.EuiHealth, { "aria-label": i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.healthStatusMessageAriaLabel', {
                    defaultMessage: 'Monitor status',
                }), color: status === 'up' ? 'success' : 'danger', style: { lineHeight: 'inherit' } }, status === 'up'
                ? i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.healthStatusMessage.upLabel', {
                    defaultMessage: 'Up',
                })
                : i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.healthStatusMessage.downLabel', {
                    defaultMessage: 'Down',
                }))),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorStatusBar.healthStatus.hostMessage", values: { host }, defaultMessage: "Host: {host}" })),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorStatusBar.healthStatus.portMessage", values: { port }, defaultMessage: "Port: {port}" })),
        react_2.default.createElement(eui_1.EuiFlexItem, { "aria-label": i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.durationTextAriaLabel', {
                defaultMessage: 'Monitor duration in milliseconds',
            }), grow: false },
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorStatusBar.healthStatus.durationInMillisecondsMessage", 
                // TODO: this should not be computed inline
                values: { duration }, defaultMessage: "{duration}ms", description: "The 'ms' is an abbreviation for 'milliseconds'." })),
        react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorStatusBar.healthStatus.schemeMessage", values: { scheme }, defaultMessage: "Scheme: {scheme}" })),
        react_2.default.createElement(eui_1.EuiFlexItem, { "aria-label": i18n_1.i18n.translate('xpack.uptime.monitorStatusBar.timestampFromNowTextAriaLabel', {
                defaultMessage: 'Time since last check',
            }), grow: false }, moment_1.default(timestamp).fromNow()))));
