"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importDefault(require("react"));
const snapshot_histogram_1 = require("./snapshot_histogram");
exports.Snapshot = ({ danger, snapshot: { up, down, total, histogram }, primary, windowWidth, }) => (react_2.default.createElement(eui_1.EuiFlexGroup, { alignItems: "baseline", gutterSize: "xl" },
    react_2.default.createElement(eui_1.EuiFlexItem, { grow: 4 },
        react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
            react_2.default.createElement("h5", null,
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.snapshot.endpointStatusTitle", defaultMessage: "Endpoint status" }))),
        react_2.default.createElement(eui_1.EuiPanel, null,
            react_2.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceEvenly", gutterSize: "xl" },
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiPanel, null,
                        react_2.default.createElement(eui_1.EuiStat, { description: i18n_1.i18n.translate('xpack.uptime.snapshot.stats.upDescription', {
                                defaultMessage: 'Up',
                            }), textAlign: "center", title: up, titleColor: "primary" }))),
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiPanel, null,
                        react_2.default.createElement(eui_1.EuiStat, { description: i18n_1.i18n.translate('xpack.uptime.snapshot.stats.downDescription', {
                                defaultMessage: 'Down',
                            }), textAlign: "center", title: down, titleColor: "danger" }))),
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiPanel, null,
                        react_2.default.createElement(eui_1.EuiStat, { description: i18n_1.i18n.translate('xpack.uptime.snapshot.stats.totalDescription', {
                                defaultMessage: 'Total',
                            }), textAlign: "center", title: total, titleColor: "subdued" })))))),
    react_2.default.createElement(eui_1.EuiFlexItem, { grow: 8, style: { paddingTop: '12px', paddingRight: '12px' } },
        react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
            react_2.default.createElement("h5", null,
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.snapshot.statusOverTimeTitle", defaultMessage: "Status over time" }))),
        react_2.default.createElement(eui_1.EuiPanel, { paddingSize: "s", style: { maxHeight: '137px' } },
            histogram && (react_2.default.createElement(snapshot_histogram_1.SnapshotHistogram, { dangerColor: danger, histogram: histogram, primaryColor: primary, windowWidth: windowWidth })),
            !histogram && (react_2.default.createElement(eui_1.EuiEmptyPrompt, { title: react_2.default.createElement(eui_1.EuiTitle, null,
                    react_2.default.createElement("h5", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.snapshot.noDataTitle", defaultMessage: "No histogram data available" }))), body: react_2.default.createElement("p", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.snapshot.noDataDescription", defaultMessage: "There is no data available for the histogram" })) }))))));
