"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const lodash_1 = require("lodash");
const moment_1 = tslib_1.__importDefault(require("moment"));
const react_2 = tslib_1.__importStar(require("react"));
const columns = [
    {
        field: 'monitor.status',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.statusColumnLabel', {
            defaultMessage: 'Status',
        }),
        render: (pingStatus) => (react_2.default.createElement(eui_1.EuiHealth, { color: pingStatus === 'up' ? 'success' : 'danger' }, pingStatus === 'up'
            ? i18n_1.i18n.translate('xpack.uptime.pingList.statusColumnHealthUpLabel', {
                defaultMessage: 'Up',
            })
            : i18n_1.i18n.translate('xpack.uptime.pingList.statusColumnHealthDownLabel', {
                defaultMessage: 'Down',
            }))),
    },
    {
        field: 'timestamp',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.timestampColumnLabel', {
            defaultMessage: 'Timestamp',
        }),
        render: (timestamp) => moment_1.default(timestamp).fromNow(),
    },
    {
        field: 'monitor.ip',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.ipAddressColumnLabel', {
            defaultMessage: 'IP',
        }),
    },
    {
        field: 'monitor.id',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.idColumnLabel', {
            defaultMessage: 'Id',
        }),
        dataType: 'string',
        width: '20%',
    },
    {
        field: 'monitor.duration.us',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.durationMsColumnLabel', {
            defaultMessage: 'Duration ms',
            description: 'The "ms" in the default message is an abbreviation for milliseconds',
        }),
        render: (duration) => duration / 1000,
    },
    {
        field: 'error.type',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.errorTypeColumnLabel', {
            defaultMessage: 'Error type',
        }),
    },
    {
        field: 'error.message',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.errorMessageColumnLabel', {
            defaultMessage: 'Error message',
        }),
        render: (message) => message && message.length > 25 ? (react_2.default.createElement(eui_1.EuiToolTip, { position: "top", title: i18n_1.i18n.translate('xpack.uptime.pingList.columns.errorMessageTooltipTitle', {
                defaultMessage: 'Error message',
            }), content: react_2.default.createElement("p", null, message) },
            react_2.default.createElement("div", null,
                message.slice(0, 24),
                "\u2026"))) : (message),
    },
    {
        field: 'http.response.status_code',
        name: i18n_1.i18n.translate('xpack.uptime.pingList.responseCodeColumnLabel', {
            defaultMessage: 'Response code',
        }),
    },
];
exports.PingList = (props) => {
    const pings = lodash_1.get(props, 'pingResults.pings');
    const total = lodash_1.get(props, 'pingResults.total');
    const { loading } = props;
    return (react_2.default.createElement(react_2.Fragment, null,
        react_2.default.createElement(eui_1.EuiFlexGroup, null,
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
                    react_2.default.createElement("h4", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.pingList.checkHistoryTitle", defaultMessage: "Check History" })))),
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false }, typeof pings !== 'undefined' && react_2.default.createElement(eui_1.EuiBadge, { color: "primary" }, total))),
        react_2.default.createElement(eui_1.EuiPanel, { paddingSize: "l" },
            react_2.default.createElement(eui_1.EuiFlexGroup, null,
                react_2.default.createElement(eui_1.EuiFlexItem, null,
                    react_2.default.createElement(eui_1.EuiFormRow, { label: i18n_1.i18n.translate('xpack.uptime.pingList.statusLabel', {
                            defaultMessage: 'Status',
                        }) },
                        react_2.default.createElement(eui_1.EuiComboBox, { isClearable: false, singleSelection: { asPlainText: true }, selectedOptions: [props.selectedOption], options: props.statusOptions, onChange: props.selectedOptionChanged })))),
            react_2.default.createElement(eui_1.EuiInMemoryTable, { loading: loading, columns: columns, items: pings, pagination: { initialPageSize: 10, pageSizeOptions: [5, 10, 20, 100] } }))));
};
