"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const moment_1 = tslib_1.__importDefault(require("moment"));
const react_2 = tslib_1.__importStar(require("react"));
const react_router_dom_1 = require("react-router-dom");
const format_sparkline_counts_1 = require("./format_sparkline_counts");
const MONITOR_LIST_DEFAULT_PAGINATION = 10;
const monitorListPagination = {
    initialPageSize: MONITOR_LIST_DEFAULT_PAGINATION,
    pageSizeOptions: [5, 10, 20, 50],
};
exports.MonitorList = ({ dangerColor, loading, monitors, primaryColor }) => (react_2.default.createElement(react_2.Fragment, null,
    react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
        react_2.default.createElement("h5", null,
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.monitorList.monitoringStatusTitle", defaultMessage: "Monitor status" }))),
    react_2.default.createElement(eui_1.EuiPanel, { paddingSize: "l" },
        react_2.default.createElement(eui_1.EuiInMemoryTable, { columns: [
                {
                    field: 'ping.monitor.status',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.statusColumnLabel', {
                        defaultMessage: 'Status',
                    }),
                    render: (status) => (react_2.default.createElement(eui_1.EuiHealth, { color: status === 'up' ? 'success' : 'danger' }, status === 'up'
                        ? i18n_1.i18n.translate('xpack.uptime.monitorList.statusColumn.upLabel', {
                            defaultMessage: 'Up',
                        })
                        : i18n_1.i18n.translate('xpack.uptime.monitorList.statusColumn.downLabel', {
                            defaultMessage: 'Down',
                        }))),
                },
                {
                    field: 'ping.timestamp',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.lastUpdatedColumnLabel', {
                        defaultMessage: 'Last updated',
                    }),
                    render: (timestamp) => moment_1.default(timestamp).fromNow(),
                },
                {
                    field: 'ping.monitor.host',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.hostColumnLabel', {
                        defaultMessage: 'Host',
                    }),
                    render: (host, monitor) => (react_2.default.createElement(react_router_dom_1.Link, { to: `/monitor/${monitor.key.id}` }, host || monitor.key.id)),
                },
                {
                    field: 'key.port',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.portColumnLabel', {
                        defaultMessage: 'Port',
                    }),
                    sortable: true,
                },
                {
                    field: 'ping.monitor.type',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.typeColumnLabel', {
                        defaultMessage: 'Type',
                    }),
                    sortable: true,
                },
                {
                    field: 'ping.monitor.ip',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.ipColumnLabel', {
                        defaultMessage: 'IP',
                    }),
                },
                {
                    field: 'upSeries',
                    name: i18n_1.i18n.translate('xpack.uptime.monitorList.monitorHistoryColumnLabel', {
                        defaultMessage: 'Monitor History',
                    }),
                    // @ts-ignore TODO fix typing
                    render: (upSeries, monitor) => {
                        const { downSeries } = monitor;
                        return (react_2.default.createElement(eui_1.EuiSeriesChart, { showDefaultAxis: false, width: 180, height: 70, stackBy: "y", 
                            // TODO: style hack
                            style: { marginBottom: '-20px' }, xType: eui_1.EuiSeriesChartUtils.SCALE.TIME, xCrosshairFormat: "YYYY-MM-DD hh:mmZ" },
                            react_2.default.createElement(eui_1.EuiHistogramSeries, { data: format_sparkline_counts_1.formatSparklineCounts(downSeries), name: i18n_1.i18n.translate('xpack.uptime.monitorList.downLineSeries.downLabel', {
                                    defaultMessage: 'Down',
                                }), color: dangerColor }),
                            react_2.default.createElement(eui_1.EuiHistogramSeries, { data: format_sparkline_counts_1.formatSparklineCounts(upSeries), name: i18n_1.i18n.translate('xpack.uptime.monitorList.upLineSeries.upLabel', {
                                    defaultMessage: 'Up',
                                }), color: primaryColor })));
                    },
                },
            ], loading: loading, items: monitors, pagination: monitorListPagination }))));
