"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
// @ts-ignore No typings for EuiSearchBar
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const react_1 = tslib_1.__importDefault(require("react"));
const search_schema_1 = require("./search_schema");
const MAX_SELECTION_LENGTH = 20;
const SEARCH_THRESHOLD = 2;
exports.FilterBar = ({ filterBar: { id, port, type }, updateQuery }) => {
    const showFilterDisclaimer = (id && id.length && id.length > MAX_SELECTION_LENGTH) ||
        (port && port.length && port.length > MAX_SELECTION_LENGTH);
    // TODO: add a factory function + type for these filter options
    const filters = [
        {
            type: 'field_value_toggle_group',
            field: 'monitor.status',
            items: [
                {
                    value: 'up',
                    name: i18n_1.i18n.translate('xpack.uptime.filterBar.filterUpLabel', {
                        defaultMessage: 'Up',
                    }),
                },
                {
                    value: 'down',
                    name: i18n_1.i18n.translate('xpack.uptime.filterBar.filterDownLabel', {
                        defaultMessage: 'Down',
                    }),
                },
            ],
        },
        // TODO: add health to this select
        {
            type: 'field_value_selection',
            field: 'monitor.id',
            name: i18n_1.i18n.translate('xpack.uptime.filterBar.options.hostLabel', {
                defaultMessage: 'ID',
            }),
            multiSelect: false,
            options: lodash_1.take(id || [], MAX_SELECTION_LENGTH).map((idValue) => ({
                value: idValue,
                view: idValue,
            })),
            searchThreshold: SEARCH_THRESHOLD,
        },
        {
            type: 'field_value_selection',
            field: 'tcp.port',
            name: i18n_1.i18n.translate('xpack.uptime.filterBar.options.portLabel', {
                defaultMessage: 'Port',
            }),
            multiSelect: false,
            options: lodash_1.take(port || [], MAX_SELECTION_LENGTH).map((portValue) => ({
                value: portValue,
                view: portValue,
            })),
            searchThreshold: SEARCH_THRESHOLD,
        },
        {
            type: 'field_value_selection',
            field: 'monitor.type',
            name: i18n_1.i18n.translate('xpack.uptime.filterBar.options.typeLabel', {
                defaultMessage: 'Type',
            }),
            multiSelect: false,
            options: type && type.map((typeValue) => ({ value: typeValue, view: typeValue })),
            searchThreshold: SEARCH_THRESHOLD,
        },
    ];
    return (react_1.default.createElement(eui_1.EuiFlexGroup, null,
        react_1.default.createElement(eui_1.EuiFlexItem, { grow: true },
            react_1.default.createElement(eui_1.EuiSearchBar
            // TODO: update typing
            , { 
                // TODO: update typing
                onChange: ({ query }) => {
                    try {
                        let esQuery;
                        if (query && query.text) {
                            esQuery = eui_1.EuiSearchBar.Query.toESQuery(query);
                        }
                        updateQuery(esQuery);
                    }
                    catch (e) {
                        updateQuery(undefined);
                    }
                }, filters: filters, schema: search_schema_1.filterBarSearchSchema })),
        showFilterDisclaimer && (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(eui_1.EuiToolTip, { position: "left", title: i18n_1.i18n.translate('xpack.uptime.filterBar.filterLimitationsTooltipTitle', {
                    defaultMessage: 'Filter limitations',
                }), content: i18n_1.i18n.translate('xpack.uptime.filterBar.filterLimitationsTooltipText', {
                    values: { selectionLength: MAX_SELECTION_LENGTH },
                    defaultMessage: 'The top {selectionLength} filter options for each field are displayed, but you can modify the filters manually or search for additional values.',
                }) },
                react_1.default.createElement(eui_1.EuiIcon, { type: "iInCircle", size: "l" }))))));
};
