"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
// @ts-ignore missing typings
const eui_1 = require("@elastic/eui");
const i18n_1 = require("@kbn/i18n");
const react_1 = require("@kbn/i18n/react");
const moment_1 = tslib_1.__importDefault(require("moment"));
const react_2 = tslib_1.__importStar(require("react"));
const react_router_dom_1 = require("react-router-dom");
exports.ErrorList = ({ loading, errorList }) => (react_2.default.createElement(react_2.Fragment, null,
    react_2.default.createElement(eui_1.EuiTitle, { size: "xs" },
        react_2.default.createElement("h5", null,
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.errorList.title", defaultMessage: "Error list" }))),
    react_2.default.createElement(eui_1.EuiPanel, null,
        react_2.default.createElement(eui_1.EuiInMemoryTable, { loading: loading, items: errorList, columns: [
                {
                    field: 'type',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.errorTypeColumnLabel', {
                        defaultMessage: 'Error type',
                    }),
                },
                {
                    field: 'monitorId',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.monitorIdColumnLabel', {
                        defaultMessage: 'Monitor ID',
                    }),
                    render: (id) => react_2.default.createElement(react_router_dom_1.Link, { to: `/monitor/${id}` }, id),
                    width: '25%',
                },
                {
                    field: 'count',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.CountColumnLabel', {
                        defaultMessage: 'Count',
                    }),
                },
                {
                    field: 'timestamp',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.latestErrorColumnLabel', {
                        defaultMessage: 'Latest error',
                    }),
                    render: (timestamp) => moment_1.default(timestamp).fromNow(),
                },
                {
                    field: 'statusCode',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.statusCodeColumnLabel', {
                        defaultMessage: 'Status code',
                    }),
                },
                {
                    field: 'latestMessage',
                    name: i18n_1.i18n.translate('xpack.uptime.errorList.latestMessageColumnLabel', {
                        defaultMessage: 'Latest message',
                    }),
                    width: '40%',
                },
            ], pagination: { initialPageSize: 10, pageSizeOptions: [5, 10, 20, 50] } }))));
