"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
exports.EmptyState = ({ children, count }) => (react_2.default.createElement(react_2.Fragment, null,
    !count && (react_2.default.createElement(eui_1.EuiEmptyPrompt, { title: react_2.default.createElement(eui_1.EuiTitle, { size: "l" },
            react_2.default.createElement("h3", null,
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.emptyState.noDataTitle", defaultMessage: "No uptime data available" }))), body: react_2.default.createElement(react_2.Fragment, null,
            react_2.default.createElement("p", null,
                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.emptyState.configureHeartbeatToGetStartedMessage", defaultMessage: "{configureHeartbeatLink} to start collecting uptime data.", values: {
                        configureHeartbeatLink: (react_2.default.createElement(eui_1.EuiLink, { target: "_blank", href: "https://www.elastic.co/guide/en/beats/heartbeat/current/configuring-howto-heartbeat.html" },
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.uptime.emptyState.configureHeartbeatLinkText", defaultMessage: "Configure Heartbeat" }))),
                    } }))) })),
    !!count && count > 0 && children));
