"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const i18n_1 = require("@kbn/i18n");
exports.monitorBreadcrumb = {
    text: i18n_1.i18n.translate('xpack.uptime.breadcrumbs.monitorBreadcrumbText', {
        defaultMessage: 'Monitor',
    }),
};
exports.overviewBreadcrumb = {
    text: i18n_1.i18n.translate('xpack.uptime.breadcrumbs.overviewBreadcrumbText', {
        defaultMessage: 'Overview',
    }),
    href: '#/',
};
exports.getOverviewPageBreadcrumbs = () => [exports.overviewBreadcrumb];
exports.getMonitorPageBreadcrumb = () => [
    exports.overviewBreadcrumb,
    exports.monitorBreadcrumb,
];
