"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const boom_1 = tslib_1.__importDefault(require("boom"));
const lodash_1 = tslib_1.__importDefault(require("lodash"));
const es_migration_apis_1 = require("../lib/es_migration_apis");
const es_version_precheck_1 = require("../lib/es_version_precheck");
function registerClusterCheckupRoutes(server) {
    const { callWithRequest } = server.plugins.elasticsearch.getCluster('admin');
    const isCloudEnabled = lodash_1.default.get(server.plugins, 'cloud.config.isCloudEnabled', false);
    server.route({
        path: '/api/upgrade_assistant/status',
        method: 'GET',
        options: {
            pre: [es_version_precheck_1.EsVersionPrecheck],
        },
        async handler(request) {
            try {
                return await es_migration_apis_1.getUpgradeAssistantStatus(callWithRequest, request, isCloudEnabled);
            }
            catch (e) {
                if (e.status === 403) {
                    return boom_1.default.forbidden(e.message);
                }
                return boom_1.default.boomify(e, {
                    statusCode: 500,
                });
            }
        },
    });
}
exports.registerClusterCheckupRoutes = registerClusterCheckupRoutes;
