"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const credential_store_1 = require("./lib/reindexing/credential_store");
const telemetry_1 = require("./lib/telemetry");
const cluster_checkup_1 = require("./routes/cluster_checkup");
const delete_tasks_1 = require("./routes/delete_tasks");
const deprecation_logging_1 = require("./routes/deprecation_logging");
const query_default_field_1 = require("./routes/query_default_field");
const reindex_indices_1 = require("./routes/reindex_indices");
const telemetry_2 = require("./routes/telemetry");
function initServer(server) {
    cluster_checkup_1.registerClusterCheckupRoutes(server);
    delete_tasks_1.registerDeleteTasksRoutes(server);
    deprecation_logging_1.registerDeprecationLoggingRoutes(server);
    query_default_field_1.registerQueryDefaultFieldRoutes(server);
    // The ReindexWorker uses a map of request headers that contain the authentication credentials
    // for a given reindex. We cannot currently store these in an the .kibana index b/c we do not
    // want to expose these credentials to any unauthenticated users. We also want to avoid any need
    // to add a user for a special index just for upgrading. This in-memory cache allows us to
    // process jobs without the browser staying on the page, but will require that jobs go into
    // a paused state if no Kibana nodes have the required credentials.
    const credentialStore = credential_store_1.credentialStoreFactory();
    const worker = reindex_indices_1.registerReindexWorker(server, credentialStore);
    reindex_indices_1.registerReindexIndicesRoutes(server, worker, credentialStore);
    // Bootstrap the needed routes and the collector for the telemetry
    telemetry_2.registerTelemetryRoutes(server);
    telemetry_1.makeUpgradeAssistantUsageCollector(server);
}
exports.initServer = initServer;
