"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
const types_1 = require("../../../../../../../common/types");
exports.idForWarning = (warning) => `reindexWarning-${warning}`;
const WarningCheckbox = ({ checkedIds, warning, label, onChange, description, documentationUrl }) => (react_1.default.createElement(react_1.Fragment, null,
    react_1.default.createElement(eui_1.EuiText, null,
        react_1.default.createElement(eui_1.EuiCheckbox, { id: exports.idForWarning(warning), label: react_1.default.createElement("strong", null, label), checked: checkedIds[exports.idForWarning(warning)], onChange: onChange }),
        react_1.default.createElement("p", { className: "upgWarningsStep__warningDescription" },
            description,
            react_1.default.createElement("br", null),
            react_1.default.createElement(eui_1.EuiLink, { href: documentationUrl, target: "_blank" },
                react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.documentationLinkLabel", defaultMessage: "Documentation" })))),
    react_1.default.createElement(eui_1.EuiSpacer, null)));
/**
 * Displays warning text about destructive changes required to reindex this index. The user
 * must acknowledge each change before being allowed to proceed.
 */
class WarningsFlyoutStep extends react_1.default.Component {
    constructor(props) {
        super(props);
        this.onChange = (e) => {
            const optionId = e.target.id;
            const nextCheckedIds = {
                ...this.state.checkedIds,
                ...{
                    [optionId]: !this.state.checkedIds[optionId],
                },
            };
            this.setState({ checkedIds: nextCheckedIds });
        };
        this.state = {
            checkedIds: props.warnings.reduce((checkedIds, warning) => {
                checkedIds[exports.idForWarning(warning)] = false;
                return checkedIds;
            }, {}),
        };
    }
    render() {
        const { warnings, closeFlyout, advanceNextStep } = this.props;
        const { checkedIds } = this.state;
        // Do not allow to proceed until all checkboxes are checked.
        const blockAdvance = Object.values(checkedIds).filter(v => v).length < warnings.length;
        return (react_1.default.createElement(react_1.Fragment, null,
            react_1.default.createElement(eui_1.EuiFlyoutBody, null,
                react_1.default.createElement(eui_1.EuiCallOut, { title: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.destructiveCallout.calloutTitle", defaultMessage: "This index requires destructive changes that can't be undone" }), color: "danger", iconType: "alert" },
                    react_1.default.createElement("p", null,
                        react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.destructiveCallout.calloutDetail", defaultMessage: "Back up your index, then proceed with the reindex by accepting each breaking change." }))),
                react_1.default.createElement(eui_1.EuiSpacer, null),
                warnings.includes(types_1.ReindexWarning.allField) && (react_1.default.createElement(WarningCheckbox, { checkedIds: checkedIds, onChange: this.onChange, warning: types_1.ReindexWarning.allField, label: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.allFieldWarningTitle", defaultMessage: "{allField} will be removed", values: {
                            allField: react_1.default.createElement(eui_1.EuiCode, null, "_all"),
                        } }), description: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.allFieldWarningDetail", defaultMessage: "The {allField} meta field is no longer supported in 7.0. Reindexing removes\n                      the {allField} field in the new index. Ensure that no application code or scripts reply on\n                      this field.", values: {
                            allField: react_1.default.createElement(eui_1.EuiCode, null, "_all"),
                        } }), documentationUrl: "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_the_literal__all_literal_meta_field_is_now_disabled_by_default" })),
                warnings.includes(types_1.ReindexWarning.booleanFields) && (react_1.default.createElement(WarningCheckbox, { checkedIds: checkedIds, onChange: this.onChange, warning: types_1.ReindexWarning.booleanFields, label: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.booleanFieldsWarningTitle", defaultMessage: "Boolean data in {_source} might change", values: { _source: react_1.default.createElement(eui_1.EuiCode, null, "_source") } }), description: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.booleanFieldsWarningDetail", defaultMessage: "If a document contain a boolean field that is neither {true} or {false}\n                   (for example, {yes}, {on}, {one}), reindexing converts these fields to {true} or {false}.\n                   Ensure that no application code or scripts rely on boolean fields in the deprecated format.", values: {
                            true: react_1.default.createElement(eui_1.EuiCode, null, "true"),
                            false: react_1.default.createElement(eui_1.EuiCode, null, "false"),
                            yes: react_1.default.createElement(eui_1.EuiCode, null, "\"yes\""),
                            on: react_1.default.createElement(eui_1.EuiCode, null, "\"on\""),
                            one: react_1.default.createElement(eui_1.EuiCode, null, "1"),
                        } }), documentationUrl: "https://www.elastic.co/guide/en/elasticsearch/reference/6.0/breaking_60_mappings_changes.html#_coercion_of_boolean_field" }))),
            react_1.default.createElement(eui_1.EuiFlyoutFooter, null,
                react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceBetween" },
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(eui_1.EuiButtonEmpty, { iconType: "cross", onClick: closeFlyout, flush: "left" },
                            react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.cancelButtonLabel", defaultMessage: "Cancel" }))),
                    react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_1.default.createElement(eui_1.EuiButton, { fill: true, color: "danger", onClick: advanceNextStep, disabled: blockAdvance },
                            react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.continueButtonLabel", defaultMessage: "Continue with reindex" })))))));
    }
}
exports.WarningsFlyoutStep = WarningsFlyoutStep;
