"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
const types_1 = require("../../../../../../../common/types");
const types_2 = require("../../../../../types");
const progress_1 = require("./progress");
const buttonLabel = (status) => {
    switch (status) {
        case types_1.ReindexStatus.failed:
            return (react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.tryAgainLabel", defaultMessage: "Try again" }));
        case types_1.ReindexStatus.inProgress:
            return (react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.reindexingLabel", defaultMessage: "Reindexing\u2026" }));
        case types_1.ReindexStatus.completed:
            return (react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.doneLabel", defaultMessage: "Done!" }));
        case types_1.ReindexStatus.paused:
            return (react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.resumeLabel", defaultMessage: "Resume" }));
        default:
            return (react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexButton.runReindexLabel", defaultMessage: "Run reindex" }));
    }
};
/**
 * Displays a flyout that shows the current reindexing status for a given index.
 */
exports.ChecklistFlyoutStep = ({ closeFlyout, reindexState, startReindex, cancelReindex }) => {
    const { loadingState, status, hasRequiredPrivileges } = reindexState;
    const loading = loadingState === types_2.LoadingState.Loading || status === types_1.ReindexStatus.inProgress;
    return (react_1.default.createElement(react_1.Fragment, null,
        react_1.default.createElement(eui_1.EuiFlyoutBody, null,
            react_1.default.createElement(eui_1.EuiCallOut, { title: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.readonlyCallout.calloutTitle", defaultMessage: "Index is unable to ingest, update, or delete documents while reindexing" }), color: "warning", iconType: "alert" },
                react_1.default.createElement("p", null,
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.readonlyCallout.cantStopDetail", defaultMessage: "If you can\u2019t stop document updates or need to reindex into a new cluster,\n                consider using a different upgrade strategy." })),
                react_1.default.createElement("p", null,
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.readonlyCallout.backgroundResumeDetail", defaultMessage: "Reindexing will continue in the background, but if Kibana shuts down or restarts you will\n                need to return to this page to resume reindexing." }))),
            !hasRequiredPrivileges && (react_1.default.createElement(react_1.Fragment, null,
                react_1.default.createElement(eui_1.EuiSpacer, null),
                react_1.default.createElement(eui_1.EuiCallOut, { title: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.insufficientPrivilegeCallout.calloutTitle", defaultMessage: "You do not have sufficient privileges to reindex this index" }), color: "danger", iconType: "alert" }))),
            react_1.default.createElement(eui_1.EuiSpacer, null),
            react_1.default.createElement(eui_1.EuiTitle, { size: "xs" },
                react_1.default.createElement("h3", null,
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.reindexingChecklistTitle", defaultMessage: "Reindexing process" }))),
            react_1.default.createElement(progress_1.ReindexProgress, { reindexState: reindexState, cancelReindex: cancelReindex })),
        react_1.default.createElement(eui_1.EuiFlyoutFooter, null,
            react_1.default.createElement(eui_1.EuiFlexGroup, { justifyContent: "spaceBetween" },
                react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                    react_1.default.createElement(eui_1.EuiButtonEmpty, { iconType: "cross", onClick: closeFlyout, flush: "left" },
                        react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.checklistStep.closeButtonLabel", defaultMessage: "Close" }))),
                react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
                    react_1.default.createElement(eui_1.EuiButton, { fill: true, color: status === types_1.ReindexStatus.paused ? 'warning' : 'primary', iconType: status === types_1.ReindexStatus.paused ? 'play' : undefined, onClick: startReindex, isLoading: loading, disabled: loading || status === types_1.ReindexStatus.completed || !hasRequiredPrivileges }, buttonLabel(status)))))));
};
