"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
const button_1 = require("./default_fields/button");
const delete_tasks_button_1 = require("./delete_tasks_button");
const reindex_1 = require("./reindex");
/**
 * Used to display a deprecation with links to docs, a health indicator, and other descriptive information.
 */
exports.DeprecationCell = ({ headline, healthColor, indexName, reindex, deleteIndex, needsDefaultFields, docUrl, items = [], children, }) => (react_1.default.createElement("div", { className: "upgDeprecationCell" },
    react_1.default.createElement(eui_1.EuiFlexGroup, { responsive: false, wrap: true, alignItems: "baseline" },
        healthColor && (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(eui_1.EuiIcon, { type: "dot", color: healthColor }))),
        react_1.default.createElement(eui_1.EuiFlexItem, { grow: true },
            headline && (react_1.default.createElement(eui_1.EuiTitle, { size: "xxs" },
                react_1.default.createElement("h2", null, headline))),
            docUrl && (react_1.default.createElement("div", null,
                react_1.default.createElement(eui_1.EuiLink, { href: docUrl, target: "_blank" },
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.checkupTab.deprecations.documentationButtonLabel", defaultMessage: "Documentation" })),
                react_1.default.createElement(eui_1.EuiSpacer, { size: "s" }))),
            items.map(item => (react_1.default.createElement("div", { key: item.title || item.body },
                react_1.default.createElement(eui_1.EuiText, null,
                    item.title && react_1.default.createElement("h6", null, item.title),
                    react_1.default.createElement("p", null, item.body)))))),
        reindex && (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(reindex_1.ReindexButton, { indexName: indexName }))),
        deleteIndex && (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(delete_tasks_button_1.DeleteTasksButton, null))),
        needsDefaultFields && (react_1.default.createElement(eui_1.EuiFlexItem, { grow: false },
            react_1.default.createElement(button_1.FixDefaultFieldsButton, { indexName: indexName })))),
    react_1.default.createElement(eui_1.EuiSpacer, { size: "s" }),
    children));
