"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
const version_1 = require("../../common/version");
exports.LatestMinorBanner = () => (react_1.default.createElement(eui_1.EuiCallOut, { title: react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.tabs.incompleteCallout.calloutTitle", defaultMessage: "Issues list might be incomplete" }), color: "warning", iconType: "help" },
    react_1.default.createElement("p", null,
        react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.tabs.incompleteCallout.calloutBody.calloutDetail", defaultMessage: "The complete list of {breakingChangesDocButton} in Elasticsearch {nextEsVersion}\n            will be available in the final {currentEsVersion} minor release. When the list\n            is complete, this warning will go away.", values: {
                breakingChangesDocButton: (react_1.default.createElement(eui_1.EuiLink, { href: "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html", target: "_blank" },
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.tabs.incompleteCallout.calloutBody.breackingChangesDocButtonLabel", defaultMessage: "deprecations and breaking changes" }))),
                nextEsVersion: `${version_1.NEXT_MAJOR_VERSION}.x`,
                currentEsVersion: `${version_1.CURRENT_MAJOR_VERSION}.x`,
            } }))));
