"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const eui_1 = require("@elastic/eui");
const react_2 = require("@kbn/i18n/react");
const version_1 = require("../common/version");
const tabs_1 = require("./components/tabs");
exports.RootComponent = () => (react_1.default.createElement(react_1.Fragment, null,
    react_1.default.createElement(eui_1.EuiPageHeader, null,
        react_1.default.createElement(eui_1.EuiPageHeaderSection, null,
            react_1.default.createElement(eui_1.EuiTitle, { size: "l" },
                react_1.default.createElement("h1", null,
                    react_1.default.createElement(react_2.FormattedMessage, { id: "xpack.upgradeAssistant.appTitle", defaultMessage: "{version} Upgrade Assistant", values: { version: `${version_1.NEXT_MAJOR_VERSION}.0` } }))))),
    react_1.default.createElement(tabs_1.UpgradeAssistantTabs, null)));
