"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const joi_1 = tslib_1.__importDefault(require("joi"));
const path_1 = require("path");
const mappings_json_1 = tslib_1.__importDefault(require("./mappings.json"));
const server_1 = require("./server");
function upgradeAssistant(kibana) {
    return new kibana.Plugin({
        id: 'upgrade_assistant',
        configPrefix: 'xpack.upgrade_assistant',
        require: ['elasticsearch'],
        uiExports: {
            managementSections: ['plugins/upgrade_assistant'],
            savedObjectSchemas: {
                'upgrade-assistant-reindex-operation': {
                    isNamespaceAgnostic: true,
                },
                'upgrade-assistant-telemetry': {
                    isNamespaceAgnostic: true,
                },
            },
            styleSheetPaths: path_1.resolve(__dirname, 'public/index.scss'),
            mappings: mappings_json_1.default,
        },
        publicDir: path_1.resolve(__dirname, 'public'),
        config() {
            return joi_1.default.object({
                enabled: joi_1.default.boolean().default(true),
            }).default();
        },
        init(server) {
            // Add server routes and initialize the plugin here
            server_1.initServer(server);
        },
    });
}
exports.upgradeAssistant = upgradeAssistant;
