"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var ReindexStep;
(function (ReindexStep) {
    // Enum values are spaced out by 10 to give us room to insert steps in between.
    ReindexStep[ReindexStep["created"] = 0] = "created";
    ReindexStep[ReindexStep["indexGroupServicesStopped"] = 10] = "indexGroupServicesStopped";
    ReindexStep[ReindexStep["readonly"] = 20] = "readonly";
    ReindexStep[ReindexStep["newIndexCreated"] = 30] = "newIndexCreated";
    ReindexStep[ReindexStep["reindexStarted"] = 40] = "reindexStarted";
    ReindexStep[ReindexStep["reindexCompleted"] = 50] = "reindexCompleted";
    ReindexStep[ReindexStep["aliasCreated"] = 60] = "aliasCreated";
    ReindexStep[ReindexStep["indexGroupServicesStarted"] = 70] = "indexGroupServicesStarted";
})(ReindexStep = exports.ReindexStep || (exports.ReindexStep = {}));
var ReindexStatus;
(function (ReindexStatus) {
    ReindexStatus[ReindexStatus["inProgress"] = 0] = "inProgress";
    ReindexStatus[ReindexStatus["completed"] = 1] = "completed";
    ReindexStatus[ReindexStatus["failed"] = 2] = "failed";
    ReindexStatus[ReindexStatus["paused"] = 3] = "paused";
    ReindexStatus[ReindexStatus["cancelled"] = 4] = "cancelled";
})(ReindexStatus = exports.ReindexStatus || (exports.ReindexStatus = {}));
exports.REINDEX_OP_TYPE = 'upgrade-assistant-reindex-operation';
var ReindexWarning;
(function (ReindexWarning) {
    ReindexWarning[ReindexWarning["allField"] = 0] = "allField";
    ReindexWarning[ReindexWarning["booleanFields"] = 1] = "booleanFields";
})(ReindexWarning = exports.ReindexWarning || (exports.ReindexWarning = {}));
var IndexGroup;
(function (IndexGroup) {
    IndexGroup["ml"] = "___ML_REINDEX_LOCK___";
    IndexGroup["watcher"] = "___WATCHER_REINDEX_LOCK___";
})(IndexGroup = exports.IndexGroup || (exports.IndexGroup = {}));
// Telemetry types
exports.UPGRADE_ASSISTANT_TYPE = 'upgrade-assistant-telemetry';
exports.UPGRADE_ASSISTANT_DOC_ID = 'upgrade-assistant-telemetry';
