"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const boom_1 = tslib_1.__importDefault(require("boom"));
const errors_1 = require("../../../lib/errors");
const space_schema_1 = require("../../../lib/space_schema");
function initPostSpacesApi(server, routePreCheckLicenseFn) {
    server.route({
        method: 'POST',
        path: '/api/spaces/space',
        async handler(request) {
            const { SavedObjectsClient } = server.savedObjects;
            const spacesClient = server.plugins.spaces.spacesClient.getScopedClient(request);
            const space = request.payload;
            try {
                return await spacesClient.create(space);
            }
            catch (error) {
                if (SavedObjectsClient.errors.isConflictError(error)) {
                    return boom_1.default.conflict(`A space with the identifier ${space.id} already exists.`);
                }
                return errors_1.wrapError(error);
            }
        },
        config: {
            validate: {
                payload: space_schema_1.spaceSchema,
            },
            pre: [routePreCheckLicenseFn],
        },
    });
}
exports.initPostSpacesApi = initPostSpacesApi;
