"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-ignore
const hapi_1 = require("hapi");
const spaces_client_1 = require("../../../lib/spaces_client");
const create_spaces_1 = require("./create_spaces");
exports.defaultPreCheckLicenseImpl = (request) => '';
const baseConfig = {
    'server.basePath': '',
    'xpack.spaces.maxSpaces': 1000,
};
function createTestHandler(initApiFn) {
    const teardowns = [];
    const spaces = create_spaces_1.createSpaces();
    const request = async (method, path, options = {}) => {
        const { setupFn = () => {
            return;
        }, testConfig = {}, payload, preCheckLicenseImpl = exports.defaultPreCheckLicenseImpl, expectSpacesClientCall = true, } = options;
        let pre = jest.fn();
        if (preCheckLicenseImpl) {
            pre = pre.mockImplementation(preCheckLicenseImpl);
        }
        const server = new hapi_1.Server();
        const config = {
            ...baseConfig,
            ...testConfig,
        };
        await setupFn(server);
        const mockConfig = {
            get: (key) => config[key],
        };
        server.decorate('server', 'config', jest.fn(() => mockConfig));
        initApiFn(server, pre);
        server.decorate('request', 'getBasePath', jest.fn());
        server.decorate('request', 'setBasePath', jest.fn());
        const mockSavedObjectsRepository = {
            get: jest.fn((type, id) => {
                const result = spaces.filter(s => s.id === id);
                if (!result.length) {
                    throw new Error(`not found: [${type}:${id}]`);
                }
                return result[0];
            }),
            find: jest.fn(() => {
                return {
                    total: spaces.length,
                    saved_objects: spaces,
                };
            }),
            create: jest.fn((type, attributes, { id }) => {
                if (spaces.find(s => s.id === id)) {
                    throw new Error('conflict');
                }
                return {};
            }),
            update: jest.fn((type, id) => {
                if (!spaces.find(s => s.id === id)) {
                    throw new Error('not found: during update');
                }
                return {};
            }),
            delete: jest.fn((type, id) => {
                return {};
            }),
            deleteByNamespace: jest.fn(),
        };
        server.savedObjects = {
            SavedObjectsClient: {
                errors: {
                    isNotFoundError: jest.fn((e) => e.message.startsWith('not found:')),
                    isConflictError: jest.fn((e) => e.message.startsWith('conflict')),
                },
            },
        };
        server.plugins.spaces = {
            spacesClient: {
                getScopedClient: jest.fn((req) => {
                    return new spaces_client_1.SpacesClient(null, null, mockSavedObjectsRepository, mockConfig, mockSavedObjectsRepository, req);
                }),
            },
        };
        teardowns.push(() => server.stop());
        const headers = {
            authorization: 'foo',
        };
        const testRun = async () => {
            const response = await server.inject({
                method,
                url: path,
                headers,
                payload,
            });
            if (preCheckLicenseImpl) {
                expect(pre).toHaveBeenCalled();
            }
            else {
                expect(pre).not.toHaveBeenCalled();
            }
            if (expectSpacesClientCall) {
                expect(server.plugins.spaces.spacesClient.getScopedClient).toHaveBeenCalledWith(expect.objectContaining({
                    headers: expect.objectContaining({
                        authorization: headers.authorization,
                    }),
                }));
            }
            else {
                expect(server.plugins.spaces.spacesClient.getScopedClient).not.toHaveBeenCalled();
            }
            return response;
        };
        return {
            server,
            headers,
            mockSavedObjectsRepository,
            response: await testRun(),
        };
    };
    return {
        request,
        teardowns,
    };
}
exports.createTestHandler = createTestHandler;
