"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
// @ts-ignore
const constants_1 = require("../../../monitoring/common/constants");
const constants_2 = require("../../common/constants");
/**
 *
 * @param callCluster
 * @param server
 * @param {boolean} spacesAvailable
 * @param withinDayRange
 * @return {ReportingUsageStats}
 */
async function getSpacesUsage(callCluster, server, spacesAvailable) {
    if (!spacesAvailable) {
        return {};
    }
    const { getSavedObjectsRepository } = server.savedObjects;
    const savedObjectsRepository = getSavedObjectsRepository(callCluster);
    const { saved_objects: spaces } = await savedObjectsRepository.find({ type: 'space' });
    return {
        count: spaces.length,
    };
}
/*
 * @param {Object} server
 * @return {Object} kibana usage stats type collection object
 */
function getSpacesUsageCollector(server) {
    const { collectorSet } = server.usage;
    return collectorSet.makeUsageCollector({
        type: constants_2.KIBANA_SPACES_STATS_TYPE,
        isReady: () => true,
        fetch: async (callCluster) => {
            const xpackInfo = server.plugins.xpack_main.info;
            const config = server.config();
            const available = xpackInfo && xpackInfo.isAvailable(); // some form of spaces is available for all valid licenses
            const enabled = config.get('xpack.spaces.enabled');
            const spacesAvailableAndEnabled = available && enabled;
            const usageStats = await getSpacesUsage(callCluster, server, spacesAvailableAndEnabled);
            return {
                available,
                enabled: spacesAvailableAndEnabled,
                ...usageStats,
            };
        },
        /*
         * Format the response data into a model for internal upload
         * 1. Make this data part of the "kibana_stats" type
         * 2. Organize the payload in the usage.xpack.spaces namespace of the data payload
         */
        formatForBulkUpload: (result) => {
            return {
                type: constants_1.KIBANA_STATS_TYPE_MONITORING,
                payload: {
                    usage: {
                        spaces: result,
                    },
                },
            };
        },
    });
}
exports.getSpacesUsageCollector = getSpacesUsageCollector;
