"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const spaces_manager_1 = require("plugins/spaces/lib/spaces_manager");
// @ts-ignore
const space_selector_html_1 = tslib_1.__importDefault(require("plugins/spaces/views/space_selector/space_selector.html"));
require("ui/autoload/styles");
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const i18n_1 = require("ui/i18n");
// @ts-ignore
const modules_1 = require("ui/modules");
require("plugins/spaces/views/space_selector/space_selector.less");
const react_1 = tslib_1.__importDefault(require("react"));
const react_dom_1 = require("react-dom");
const space_selector_1 = require("./space_selector");
const module = modules_1.uiModules.get('spaces_selector', []);
module.controller('spacesSelectorController', ($scope, $http, spaces, spaceSelectorURL) => {
    const domNode = document.getElementById('spaceSelectorRoot');
    const spacesManager = new spaces_manager_1.SpacesManager($http, chrome_1.default, spaceSelectorURL);
    react_dom_1.render(react_1.default.createElement(i18n_1.I18nContext, null,
        react_1.default.createElement(space_selector_1.SpaceSelector, { spaces: spaces, spacesManager: spacesManager })), domNode);
    // unmount react on controller destroy
    $scope.$on('$destroy', () => {
        if (domNode) {
            react_dom_1.unmountComponentAtNode(domNode);
        }
    });
});
chrome_1.default.setVisible(false).setRootTemplate(space_selector_html_1.default);
