"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("./constants");
function getAvailablePrivileges(minimumPrivilege) {
    switch (minimumPrivilege) {
        case constants_1.NO_PRIVILEGE_VALUE:
            return ['read', 'all'];
        case 'read':
            return ['read', 'all'];
        case 'all':
            return ['all'];
        default:
            throw new Error(`Unexpected minimumPrivilege value: ${minimumPrivilege}`);
    }
}
exports.getAvailablePrivileges = getAvailablePrivileges;
