"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = tslib_1.__importStar(require("react"));
const space_attributes_1 = require("../../../../../../../../spaces/common/space_attributes");
const spaceToOption = (space) => {
    if (!space) {
        return { label: '', isGroupLabelOption: false };
    }
    return {
        id: space.id,
        label: space.name,
        color: space_attributes_1.getSpaceColor(space),
        isGroupLabelOption: false,
    };
};
const spaceIdToOption = (spaces) => (s) => spaceToOption(spaces.find(space => space.id === s));
class SpaceSelector extends react_1.Component {
    constructor() {
        super(...arguments);
        this.onChange = (selectedSpaces) => {
            this.props.onChange(selectedSpaces.map(s => s.id));
        };
    }
    render() {
        const renderOption = (option, searchValue, contentClassName) => {
            const { color, label } = option;
            return (react_1.default.createElement(eui_1.EuiHealth, { color: color },
                react_1.default.createElement("span", { className: contentClassName },
                    react_1.default.createElement(eui_1.EuiHighlight, { search: searchValue }, label))));
        };
        return (react_1.default.createElement(eui_1.EuiComboBox, { options: this.props.spaces.map(spaceToOption), renderOption: renderOption, selectedOptions: this.props.selectedSpaceIds.map(spaceIdToOption(this.props.spaces)), isDisabled: this.props.disabled, onChange: this.onChange }));
    }
}
exports.SpaceSelector = SpaceSelector;
