"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const role_1 = require("../../../../../../lib/role");
const constants_1 = require("../../../lib/constants");
const copy_role_1 = require("../../../lib/copy_role");
const get_available_privileges_1 = require("../../../lib/get_available_privileges");
const impacted_spaces_flyout_1 = require("./impacted_spaces_flyout");
const privilege_callout_warning_1 = require("./privilege_callout_warning");
const privilege_selector_1 = require("./privilege_selector");
const privilege_space_form_1 = require("./privilege_space_form");
const privilege_space_table_1 = require("./privilege_space_table");
class SpaceAwarePrivilegeFormUI extends react_2.Component {
    constructor(props) {
        super(props);
        this.renderSpacePrivileges = (basePrivilege, availablePrivileges) => {
            const { role, spaces } = this.props;
            const { spacePrivileges } = this.state;
            const availableSpaces = this.getAvailableSpaces();
            const canAssignSpacePrivileges = basePrivilege !== 'all';
            const hasAssignedSpacePrivileges = Object.keys(this.state.spacePrivileges).length > 0;
            const showAddPrivilegeButton = canAssignSpacePrivileges && this.props.editable && availableSpaces.length > 0;
            return (react_2.default.createElement(react_2.Fragment, null,
                react_2.default.createElement(eui_1.EuiTitle, { size: 'xs' },
                    react_2.default.createElement("h3", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.higherPrivilegesForIndividualSpacesTitle", defaultMessage: "Higher privileges for individual spaces" }))),
                react_2.default.createElement(eui_1.EuiSpacer, { size: 's' }),
                react_2.default.createElement(eui_1.EuiText
                // @ts-ignore
                , { 
                    // @ts-ignore
                    grow: false, size: 's', color: 'subdued' },
                    react_2.default.createElement("p", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.grantMorePrivilegesTitle", defaultMessage: "Grant more privileges on a per space basis. For example, if the privileges are\n              {read} for all spaces, you can set the privileges to {all}\n              for an individual space.", values: {
                                read: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.readText", defaultMessage: "read" }))),
                                all: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.allText", defaultMessage: "all" }))),
                            } }))),
                react_2.default.createElement(eui_1.EuiSpacer, { size: 's' }),
                (basePrivilege !== constants_1.NO_PRIVILEGE_VALUE || role_1.isReservedRole(this.props.role)) && (react_2.default.createElement(privilege_callout_warning_1.PrivilegeCalloutWarning, { basePrivilege: basePrivilege, isReservedRole: role_1.isReservedRole(this.props.role) })),
                basePrivilege === 'read' && this.props.editable && react_2.default.createElement(eui_1.EuiSpacer, null),
                canAssignSpacePrivileges && (react_2.default.createElement(react_2.Fragment, null,
                    react_2.default.createElement(privilege_space_table_1.PrivilegeSpaceTable, { role: role, spaces: spaces, availablePrivileges: availablePrivileges, spacePrivileges: spacePrivileges, onChange: this.onExistingSpacePrivilegesChange }),
                    hasAssignedSpacePrivileges && react_2.default.createElement(eui_1.EuiSpacer, null),
                    this.getSpaceForms(basePrivilege))),
                react_2.default.createElement(eui_1.EuiFlexGroup
                // @ts-ignore
                , { 
                    // @ts-ignore
                    alignItems: 'baseline' },
                    showAddPrivilegeButton && (react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                        react_2.default.createElement(eui_1.EuiButton, { "data-test-subj": "addSpacePrivilegeButton", size: 's', iconType: 'plusInCircle', onClick: this.addSpacePrivilege },
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.addSpacePrivilegeTitle", defaultMessage: "Add space privilege" })))),
                    react_2.default.createElement(eui_1.EuiFlexItem, null,
                        react_2.default.createElement(impacted_spaces_flyout_1.ImpactedSpacesFlyout, { role: role, spaces: spaces, userProfile: this.props.userProfile })))));
        };
        this.getSpaceForms = (basePrivilege) => {
            if (!this.props.editable) {
                return null;
            }
            return this.state.privilegeForms.map((form, index) => this.getSpaceForm(form, index, basePrivilege));
        };
        this.addSpacePrivilege = () => {
            this.setState({
                privilegeForms: [
                    ...this.state.privilegeForms,
                    {
                        spaces: [],
                        privilege: null,
                    },
                ],
            });
        };
        this.getAvailableSpaces = (omitIndex) => {
            const { spacePrivileges } = this.state;
            return this.props.spaces.filter(space => {
                const alreadyAssigned = Object.keys(spacePrivileges).indexOf(space.id) >= 0;
                if (alreadyAssigned) {
                    return false;
                }
                const otherForms = [...this.state.privilegeForms];
                if (typeof omitIndex === 'number') {
                    otherForms.splice(omitIndex, 1);
                }
                const inAnotherForm = otherForms.some(({ spaces }) => spaces.indexOf(space.id) >= 0);
                return !inAnotherForm;
            });
        };
        this.getSpaceForm = (form, index, basePrivilege) => {
            const { spaces: selectedSpaceIds, privilege } = form;
            const availableSpaces = this.getAvailableSpaces(index);
            return (react_2.default.createElement(react_2.Fragment, { key: index },
                react_2.default.createElement(privilege_space_form_1.PrivilegeSpaceForm, { key: index, availableSpaces: availableSpaces, selectedSpaceIds: selectedSpaceIds, availablePrivileges: get_available_privileges_1.getAvailablePrivileges(basePrivilege), selectedPrivilege: privilege, onChange: this.onPrivilegeSpacePermissionChange(index), onDelete: this.onPrivilegeSpacePermissionDelete(index), validator: this.props.validator }),
                react_2.default.createElement(eui_1.EuiSpacer, null)));
        };
        this.onPrivilegeSpacePermissionChange = (index) => (form) => {
            const existingPrivilegeForm = { ...this.state.privilegeForms[index] };
            const updatedPrivileges = [...this.state.privilegeForms];
            updatedPrivileges[index] = {
                spaces: form.spaces,
                privilege: form.privilege,
            };
            this.setState({
                privilegeForms: updatedPrivileges,
            });
            const role = copy_role_1.copyRole(this.props.role);
            existingPrivilegeForm.spaces.forEach(spaceId => {
                role.kibana.space[spaceId] = [];
            });
            if (form.spaces.length) {
                const privilege = form.privilege;
                if (privilege) {
                    form.spaces.forEach(spaceId => {
                        role.kibana.space[spaceId] = [privilege];
                    });
                }
            }
            this.props.validator.setInProgressSpacePrivileges(updatedPrivileges);
            this.props.onChange(role);
        };
        this.onPrivilegeSpacePermissionDelete = (index) => () => {
            const updatedPrivileges = [...this.state.privilegeForms];
            const removedPrivilege = updatedPrivileges.splice(index, 1)[0];
            this.setState({
                privilegeForms: updatedPrivileges,
            });
            const role = copy_role_1.copyRole(this.props.role);
            removedPrivilege.spaces.forEach(spaceId => {
                delete role.kibana.space[spaceId];
            });
            this.props.validator.setInProgressSpacePrivileges(updatedPrivileges);
            this.props.onChange(role);
        };
        this.onExistingSpacePrivilegesChange = (assignedPrivileges) => {
            const role = copy_role_1.copyRole(this.props.role);
            role.kibana.space = {
                ...assignedPrivileges,
            };
            // Merge in-progress forms
            this.state.privilegeForms.forEach(inProgressForm => {
                const { privilege } = inProgressForm;
                if (privilege) {
                    inProgressForm.spaces.forEach(spaceId => {
                        role.kibana.space[spaceId] = [privilege];
                    });
                }
            });
            this.setState({
                spacePrivileges: assignedPrivileges,
            });
            this.props.onChange(role);
        };
        this.onKibanaBasePrivilegeChange = (privilege) => {
            const role = copy_role_1.copyRole(this.props.role);
            // Remove base privilege value
            role.kibana.global = [];
            if (privilege !== constants_1.NO_PRIVILEGE_VALUE) {
                role.kibana.global = [privilege];
            }
            this.props.onChange(role);
        };
        const { role } = props;
        const assignedPrivileges = role.kibana;
        const spacePrivileges = {
            ...assignedPrivileges.space,
        };
        this.state = {
            spacePrivileges,
            privilegeForms: [],
        };
    }
    render() {
        const { kibanaAppPrivileges, role, userProfile, intl } = this.props;
        if (!userProfile.hasCapability('manageSpaces')) {
            return (react_2.default.createElement(eui_1.EuiCallOut, { title: react_2.default.createElement("p", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.insufficientPrivilegesDescription", defaultMessage: "Insufficient Privileges" })), iconType: "alert", color: "danger" },
                react_2.default.createElement("p", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.howToViewAllAvailableSpacesDescription", defaultMessage: "You are not authorized to view all available spaces." })),
                react_2.default.createElement("p", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.ensureAccountHasAllPrivilegesGrantedDescription", defaultMessage: "Please ensure your account has all privileges granted by the\n              {kibanaUser} role, and try again.", values: {
                            kibanaUser: (react_2.default.createElement("strong", null,
                                react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.kibanaUserTitle", defaultMessage: "kibana_user" }))),
                        } }))));
        }
        const assignedPrivileges = role.kibana;
        const basePrivilege = assignedPrivileges.global.length > 0 ? assignedPrivileges.global[0] : constants_1.NO_PRIVILEGE_VALUE;
        const description = (react_2.default.createElement("p", null,
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.minimumActionsUserCanPerformInYourSpacesDescription", defaultMessage: "Specify the minimum actions users can perform in your spaces." })));
        let helptext;
        if (basePrivilege === constants_1.NO_PRIVILEGE_VALUE) {
            helptext = intl.formatMessage({
                id: 'xpack.security.management.editRoles.spaceAwarePrivilegeForm.noAccessToSpacesHelpText',
                defaultMessage: 'No access to spaces',
            });
        }
        else if (basePrivilege === 'all') {
            helptext = intl.formatMessage({
                id: 'xpack.security.management.editRoles.spaceAwarePrivilegeForm.viewEditShareAppsWithinAllSpacesHelpText',
                defaultMessage: 'View, edit, and share objects and apps within all spaces',
            });
        }
        else if (basePrivilege === 'read') {
            helptext = intl.formatMessage({
                id: 'xpack.security.management.editRoles.spaceAwarePrivilegeForm.viewObjectsAndAppsWithinAllSpacesHelpText',
                defaultMessage: 'View objects and apps within all spaces',
            });
        }
        return (react_2.default.createElement(react_2.Fragment, null,
            react_2.default.createElement(eui_1.EuiDescribedFormGroup, { title: react_2.default.createElement("h3", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.spaceAwarePrivilegeForm.minPrivilegesForAllSpacesTitle", defaultMessage: "Minimum privileges for all spaces" })), description: description },
                react_2.default.createElement(eui_1.EuiFormRow, { hasEmptyLabelSpace: true, helpText: helptext },
                    react_2.default.createElement(privilege_selector_1.PrivilegeSelector, { "data-test-subj": 'kibanaMinimumPrivilege', availablePrivileges: kibanaAppPrivileges, value: basePrivilege, disabled: role_1.isReservedRole(role), allowNone: true, onChange: this.onKibanaBasePrivilegeChange }))),
            react_2.default.createElement(eui_1.EuiSpacer, null),
            this.renderSpacePrivileges(basePrivilege, kibanaAppPrivileges)));
    }
}
exports.SpaceAwarePrivilegeForm = react_1.injectI18n(SpaceAwarePrivilegeFormUI);
