"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const role_1 = require("../../../../../../lib/role");
const constants_1 = require("../../../lib/constants");
const copy_role_1 = require("../../../lib/copy_role");
const privilege_selector_1 = require("./privilege_selector");
class SimplePrivilegeForm extends react_2.Component {
    constructor() {
        super(...arguments);
        this.onKibanaPrivilegeChange = (privilege) => {
            const role = copy_role_1.copyRole(this.props.role);
            // Remove base privilege value
            role.kibana.global = [];
            if (privilege !== constants_1.NO_PRIVILEGE_VALUE) {
                role.kibana.global = [privilege];
            }
            this.props.onChange(role);
        };
    }
    render() {
        const { kibanaAppPrivileges, role } = this.props;
        const assignedPrivileges = role.kibana;
        const kibanaPrivilege = assignedPrivileges.global.length > 0
            ? assignedPrivileges.global[0]
            : constants_1.NO_PRIVILEGE_VALUE;
        const description = (react_2.default.createElement("p", null,
            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.simplePrivilegeForm.specifyPrivilegeForRoleDescription", defaultMessage: "Specifies the Kibana privilege for this role." })));
        return (react_2.default.createElement(react_2.Fragment, null,
            react_2.default.createElement(eui_1.EuiDescribedFormGroup, { title: react_2.default.createElement("h3", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.simplePrivilegeForm.kibanaPrivilegesTitle", defaultMessage: "Kibana privileges" })), description: description },
                react_2.default.createElement(eui_1.EuiFormRow, { hasEmptyLabelSpace: true },
                    react_2.default.createElement(privilege_selector_1.PrivilegeSelector, { "data-test-subj": 'kibanaPrivilege', availablePrivileges: kibanaAppPrivileges, value: kibanaPrivilege, disabled: role_1.isReservedRole(role), allowNone: true, onChange: this.onKibanaPrivilegeChange })))));
    }
}
exports.SimplePrivilegeForm = SimplePrivilegeForm;
