"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const privilege_selector_1 = require("./privilege_selector");
const space_selector_1 = require("./space_selector");
class PrivilegeSpaceFormUI extends react_2.Component {
    constructor() {
        super(...arguments);
        this.onSelectedSpacesChange = (selectedSpaceIds) => {
            this.props.onChange({
                spaces: selectedSpaceIds,
                privilege: this.props.selectedPrivilege,
            });
        };
        this.onPrivilegeChange = (privilege) => {
            this.props.onChange({
                spaces: this.props.selectedSpaceIds,
                privilege,
            });
        };
    }
    render() {
        const { availableSpaces, selectedSpaceIds, availablePrivileges, selectedPrivilege, validator, intl, } = this.props;
        return (react_2.default.createElement(eui_1.EuiFlexGroup, { responsive: false },
            react_2.default.createElement(eui_1.EuiFlexItem, null,
                react_2.default.createElement(eui_1.EuiFormRow, Object.assign({ label: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeSpaceForm.spacesFormRowLabel", defaultMessage: "Spaces" }) }, validator.validateSelectedSpaces(selectedSpaceIds, selectedPrivilege)),
                    react_2.default.createElement(space_selector_1.SpaceSelector, { spaces: availableSpaces, selectedSpaceIds: selectedSpaceIds, onChange: this.onSelectedSpacesChange }))),
            react_2.default.createElement(eui_1.EuiFlexItem, null,
                react_2.default.createElement(eui_1.EuiFormRow, Object.assign({ label: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeSpaceForm.privilegeFormRowLabel", defaultMessage: "Privilege" }) }, validator.validateSelectedPrivilege(selectedSpaceIds, selectedPrivilege)),
                    react_2.default.createElement(privilege_selector_1.PrivilegeSelector, { "data-test-subj": 'space-form-priv-selector', availablePrivileges: availablePrivileges, value: selectedPrivilege, onChange: this.onPrivilegeChange }))),
            react_2.default.createElement(eui_1.EuiFlexItem, { grow: false },
                react_2.default.createElement(eui_1.EuiFormRow, { hasEmptyLabelSpace: true },
                    react_2.default.createElement(eui_1.EuiButtonIcon, { "aria-label": intl.formatMessage({
                            id: 'xpack.security.management.editRoles.privilegeSpaceForm.deleteSpacePrivilegeAriaLabel',
                            defaultMessage: 'Delete space privilege',
                        }), color: 'danger', onClick: this.props.onDelete, iconType: 'trash' })))));
    }
}
exports.PrivilegeSpaceForm = react_1.injectI18n(PrivilegeSpaceFormUI);
