"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const constants_1 = require("../../../lib/constants");
class PrivilegeCalloutWarning extends react_2.Component {
    constructor() {
        super(...arguments);
        this.state = {
            showImpactedSpaces: false,
        };
    }
    render() {
        const { basePrivilege, isReservedRole } = this.props;
        let callout = null;
        if (basePrivilege === 'all') {
            if (isReservedRole) {
                callout = (react_2.default.createElement(eui_1.EuiCallOut, { color: "warning", iconType: "iInCircle", title: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.notPossibleToCustomizeReservedRoleSpacePrivilegesTitle", defaultMessage: "Cannot customize a reserved role's space privileges" }) },
                    react_2.default.createElement("p", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.howToCustomizePrivilegesDescription", defaultMessage: "This role always grants full access to all spaces. To customize privileges for\n                individual spaces, you must create a new role." }))));
            }
            else {
                callout = (react_2.default.createElement(eui_1.EuiCallOut, { color: "warning", iconType: "iInCircle", title: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.minimumPrivilegeTitle", defaultMessage: "Minimum privilege is too high to customize individual spaces" }) },
                    react_2.default.createElement("p", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.howToCustomizePrivilegesForIndividualSpacesDescription", defaultMessage: "Setting the minimum privilege to {allText} grants full access to all\n                spaces. To customize privileges for individual spaces, the minimum privilege must be\n                either {readText} or {noneText}.", values: {
                                allText: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.allText", defaultMessage: "all" }))),
                                readText: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.readText", defaultMessage: "read" }))),
                                noneText: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.noneText", defaultMessage: "none" }))),
                            } }))));
            }
        }
        if (basePrivilege === 'read') {
            if (isReservedRole) {
                callout = (react_2.default.createElement(eui_1.EuiCallOut, { color: "warning", iconType: "iInCircle", title: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.notPossibleToCustomizeReservedRoleSpacePrivilegesTitle", defaultMessage: "Cannot customize a reserved role's space privileges" }) },
                    react_2.default.createElement("p", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.alwaysGrantReadAccessToAllSpacesTitle", defaultMessage: "This role always grants read access to all spaces. To customize privileges for\n                individual spaces, you must create a new role." }))));
            }
            else {
                callout = (react_2.default.createElement(eui_1.EuiCallOut, { color: "primary", iconType: "iInCircle", title: react_2.default.createElement("span", null,
                        react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.minimalPossiblePrivilageTitle", defaultMessage: "The minimal possible privilege is {readText}.", values: {
                                readText: (react_2.default.createElement("strong", null,
                                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.readText", defaultMessage: "read" }))),
                            } })) }));
            }
        }
        if (basePrivilege === constants_1.NO_PRIVILEGE_VALUE && isReservedRole) {
            callout = (react_2.default.createElement(eui_1.EuiCallOut, { color: "warning", iconType: "iInCircle", title: react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.notPossibleToCustomizeReservedRoleSpacePrivilegesTitle", defaultMessage: "Cannot customize a reserved role's space privileges" }) },
                react_2.default.createElement("p", null,
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.privilegeCalloutWarning.neverGrantReadAccessToAllSpacesTitle", defaultMessage: "This role never grants access to any spaces within Kibana. To customize privileges for\n              individual spaces, you must create a new role." }))));
        }
        return callout;
    }
}
exports.PrivilegeCalloutWarning = PrivilegeCalloutWarning;
