"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const collapsible_panel_1 = require("../../collapsible_panel");
const simple_privilege_form_1 = require("./simple_privilege_form");
const space_aware_privilege_form_1 = require("./space_aware_privilege_form");
class KibanaPrivileges extends react_1.Component {
    constructor() {
        super(...arguments);
        this.getForm = () => {
            const { kibanaAppPrivileges, role, spacesEnabled, spaces = [], userProfile, onChange, editable, validator, } = this.props;
            if (spacesEnabled) {
                return (react_1.default.createElement(space_aware_privilege_form_1.SpaceAwarePrivilegeForm, { kibanaAppPrivileges: kibanaAppPrivileges, role: role, spaces: spaces, userProfile: userProfile, onChange: onChange, editable: editable, validator: validator }));
            }
            else {
                return (react_1.default.createElement(simple_privilege_form_1.SimplePrivilegeForm, { kibanaAppPrivileges: kibanaAppPrivileges, role: role, onChange: onChange, editable: editable }));
            }
        };
    }
    render() {
        return (react_1.default.createElement(collapsible_panel_1.CollapsiblePanel, { iconType: 'logoKibana', title: 'Kibana' }, this.getForm()));
    }
}
exports.KibanaPrivileges = KibanaPrivileges;
