"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
const privilege_space_table_1 = require("./privilege_space_table");
const components_1 = require("../../../../../../../../spaces/public/components");
const constants_1 = require("../../../lib/constants");
class ImpactedSpacesFlyoutUI extends react_2.Component {
    constructor(props) {
        super(props);
        this.toggleShowImpactedSpaces = () => {
            this.setState({
                showImpactedSpaces: !this.state.showImpactedSpaces,
            });
        };
        this.getFlyout = () => {
            if (!this.state.showImpactedSpaces) {
                return null;
            }
            const { role, spaces } = this.props;
            const assignedPrivileges = role.kibana;
            const basePrivilege = assignedPrivileges.global.length
                ? assignedPrivileges.global[0]
                : constants_1.NO_PRIVILEGE_VALUE;
            const allSpacePrivileges = spaces.reduce((acc, space) => {
                const spacePrivilege = assignedPrivileges.space[space.id]
                    ? assignedPrivileges.space[space.id][0]
                    : basePrivilege;
                const actualPrivilege = this.getHighestPrivilege(spacePrivilege, basePrivilege);
                return {
                    ...acc,
                    // Use the privilege assigned to the space, if provided. Otherwise, the baes privilege is used.
                    [space.id]: [actualPrivilege],
                };
            }, { ...role.kibana.space });
            return (react_2.default.createElement(eui_1.EuiFlyout, { onClose: this.toggleShowImpactedSpaces, "aria-labelledby": "showImpactedSpacesTitle", size: "s" },
                react_2.default.createElement(eui_1.EuiFlyoutHeader, { hasBorder: true },
                    react_2.default.createElement(eui_1.EuiTitle, { size: "m" },
                        react_2.default.createElement("h1", { id: "showImpactedSpacesTitle" },
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.impactedSpacesFlyout.spacePrivilegesSummaryTitle", defaultMessage: "Summary of space privileges" })))),
                react_2.default.createElement(eui_1.EuiFlyoutBody, null,
                    react_2.default.createElement(privilege_space_table_1.PrivilegeSpaceTable, { readonly: true, role: role, spaces: spaces, spacePrivileges: allSpacePrivileges })),
                react_2.default.createElement(eui_1.EuiFlyoutFooter, { className: "showImpactedSpaces--flyout--footer" },
                    react_2.default.createElement(components_1.ManageSpacesButton, { userProfile: this.props.userProfile }))));
        };
        this.state = {
            showImpactedSpaces: false,
        };
    }
    render() {
        const flyout = this.getFlyout();
        return (react_2.default.createElement(react_2.Fragment, null,
            react_2.default.createElement("div", { className: "showImpactedSpaces" },
                react_2.default.createElement(eui_1.EuiLink, { onClick: this.toggleShowImpactedSpaces },
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.management.editRoles.impactedSpacesFlyout.viewSpacesPrivilegesSummaryLinkText", defaultMessage: "View summary of spaces privileges" }))),
            flyout));
    }
    getHighestPrivilege(...privileges) {
        const { intl } = this.props;
        if (privileges.indexOf('all') >= 0) {
            return intl.formatMessage({
                id: 'xpack.security.management.editRoles.impactedSpacesFlyout.allLabel',
                defaultMessage: 'all',
            });
        }
        if (privileges.indexOf('read') >= 0) {
            return intl.formatMessage({
                id: 'xpack.security.management.editRoles.impactedSpacesFlyout.readLabel',
                defaultMessage: 'read',
            });
        }
        return intl.formatMessage({
            id: 'xpack.security.management.editRoles.impactedSpacesFlyout.noneLabel',
            defaultMessage: 'none',
        });
    }
}
exports.ImpactedSpacesFlyout = react_1.injectI18n(ImpactedSpacesFlyoutUI);
