"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const i18n_1 = require("@kbn/i18n");
const lodash_1 = require("lodash");
const parse_next_1 = require("plugins/security/lib/parse_next");
const components_1 = require("plugins/security/views/login/components");
// @ts-ignore
const login_html_1 = tslib_1.__importDefault(require("plugins/security/views/login/login.html"));
const react_1 = tslib_1.__importDefault(require("react"));
const react_dom_1 = require("react-dom");
require("ui/autoload/styles");
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const i18n_2 = require("ui/i18n");
const url_1 = require("url");
require("./login.less");
const messageMap = {
    SESSION_EXPIRED: i18n_1.i18n.translate('xpack.security.login.sessionExpiredDescription', {
        defaultMessage: 'Your session has timed out. Please log in again.',
    }),
};
chrome_1.default
    .setVisible(false)
    .setRootTemplate(login_html_1.default)
    .setRootController('login', ($scope, $http, $window, secureCookies, loginState) => {
    const basePath = chrome_1.default.getBasePath();
    const next = parse_next_1.parseNext($window.location.href, basePath);
    const isSecure = !!$window.location.protocol.match(/^https/);
    $scope.$$postDigest(() => {
        const domNode = document.getElementById('reactLoginRoot');
        const msgQueryParam = url_1.parse($window.location.href, true).query.msg || '';
        react_dom_1.render(react_1.default.createElement(i18n_2.I18nContext, null,
            react_1.default.createElement(components_1.LoginPage, { http: $http, window: $window, infoMessage: lodash_1.get(messageMap, msgQueryParam), loginState: loginState, isSecureConnection: isSecure, requiresSecureConnection: secureCookies, next: next })), domNode);
    });
});
