"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
// @ts-ignore
const logged_out_html_1 = tslib_1.__importDefault(require("plugins/security/views/logged_out/logged_out.html"));
const react_1 = tslib_1.__importDefault(require("react"));
const react_dom_1 = require("react-dom");
require("ui/autoload/styles");
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const i18n_1 = require("ui/i18n");
require("./logged_out.less");
const components_1 = require("./components");
chrome_1.default
    .setVisible(false)
    .setRootTemplate(logged_out_html_1.default)
    .setRootController('logout', ($scope) => {
    $scope.$$postDigest(() => {
        const domNode = document.getElementById('reactLoggedOutRoot');
        react_dom_1.render(react_1.default.createElement(i18n_1.I18nContext, null,
            react_1.default.createElement(components_1.LoggedOutPage, { addBasePath: chrome_1.default.addBasePath })), domNode);
    });
});
