"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const eui_1 = require("@elastic/eui");
const react_1 = require("@kbn/i18n/react");
const react_2 = tslib_1.__importStar(require("react"));
class LoggedOutPage extends react_2.Component {
    render() {
        return (react_2.default.createElement("div", { className: "loggedOut" },
            react_2.default.createElement("header", { className: "loggedOut__header" },
                react_2.default.createElement("div", { className: "loggedOut__content eui-textCenter" },
                    react_2.default.createElement(eui_1.EuiSpacer, { size: "xxl" }),
                    react_2.default.createElement("span", { className: "loggedOut__logo" },
                        react_2.default.createElement(eui_1.EuiIcon, { type: "logoKibana", size: "xxl" })),
                    react_2.default.createElement(eui_1.EuiTitle, { size: "l", className: "loggedOut__title" },
                        react_2.default.createElement("h1", null,
                            react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.loggedOut.title", defaultMessage: "Successfully logged out" }))),
                    react_2.default.createElement(eui_1.EuiSpacer, { size: "xl" }))),
            react_2.default.createElement("div", { className: "loggedOut__content eui-textCenter" },
                react_2.default.createElement(eui_1.EuiButton, { href: this.props.addBasePath('/') },
                    react_2.default.createElement(react_1.FormattedMessage, { id: "xpack.security.loggedOut.login", defaultMessage: "Login" })))));
    }
}
exports.LoggedOutPage = LoggedOutPage;
