"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const lodash_1 = require("lodash");
const chrome_1 = tslib_1.__importDefault(require("ui/chrome"));
const apiBase = chrome_1.default.addBasePath(`/api/security/role`);
async function saveRole($http, role) {
    const data = lodash_1.omit(role, 'name', 'transient_metadata', '_unrecognized_applications');
    return await $http.put(`${apiBase}/${role.name}`, data);
}
exports.saveRole = saveRole;
async function deleteRole($http, name) {
    return await $http.delete(`${apiBase}/${name}`);
}
exports.deleteRole = deleteRole;
