/*
* Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
* or more contributor license agreements. Licensed under the Elastic License;
* you may not use this file except in compliance with the Elastic License.
*/

import { mergeJobConfigurations } from './jobs_compatibility';

export function getCapabilitiesForRollupIndices(indices) {
  const indexNames = Object.keys(indices);
  const capabilities = {};

  indexNames.forEach(index => {
    try {
      capabilities[index] = mergeJobConfigurations(indices[index].rollup_jobs);
    } catch(e) {
      capabilities[index] = {
        error: e.message,
      };
    }
  });

  return capabilities;
}
