"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const browser_types_1 = require("../browsers/browser_types");
exports.validateBrowser = async (browserFactory, log) => {
    if (browserFactory.type === browser_types_1.CHROMIUM) {
        return browserFactory
            .test({
            viewport: {
                width: 800,
                height: 600,
            },
        }, log)
            .then((browser) => {
            if (browser && browser.close) {
                browser.close();
            }
        });
    }
};
