"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConditionalHeaders = ({ job, filteredHeaders, server, }) => {
    const config = server.config();
    const conditionalHeaders = {
        headers: filteredHeaders,
        conditions: {
            hostname: config.get('xpack.reporting.kibanaServer.hostname') || config.get('server.host'),
            port: config.get('xpack.reporting.kibanaServer.port') || config.get('server.port'),
            basePath: config.get('server.basePath'),
            protocol: config.get('xpack.reporting.kibanaServer.protocol') || server.info.protocol,
        },
    };
    return { job, conditionalHeaders, server };
};
