/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
/* eslint-disable max-len */

import { i18n } from '@kbn/i18n';

export const getFlightsSavedObjects = () => {
  return [
    {
      "id": "5dd88580-1906-11e9-919b-ffe5949a18d2",
      "type": "map",
      "updated_at": "2019-01-15T20:44:54.767Z",
      "version": 2,
      "attributes": {
        "title": i18n.translate('xpack.maps.sampleData.flightaSpec.mapsTitle', {
          defaultMessage: '[Flights] Origin and Destination Flight Time'
        }),
        "description": "",
        "mapStateJSON": "{\"zoom\":3.14,\"center\":{\"lon\":-89.58746,\"lat\":38.38637},\"timeFilters\":{\"from\":\"now-7d\",\"to\":\"now\"},\"refreshConfig\":{\"isPaused\":true,\"interval\":0},\"query\":{\"query\":\"\",\"language\":\"kuery\"}}",
        "layerListJSON": "[{\"id\":\"0hmz5\",\"alpha\":1,\"sourceDescriptor\":{\"type\":\"EMS_TMS\",\"id\":\"road_map\"},\"visible\":true,\"style\":{\"type\":\"TILE\",\"properties\":{}},\"type\":\"TILE\",\"minZoom\":0,\"maxZoom\":24},{\"id\":\"jzppx\",\"label\":\"Flights\",\"minZoom\":9,\"maxZoom\":24,\"alpha\":1,\"sourceDescriptor\":{\"id\":\"040e0f25-9687-4569-a1e0-76f1a108da56\",\"type\":\"ES_SEARCH\",\"indexPatternId\":\"d3d7af60-4c81-11e8-b3d7-01146121b73d\",\"geoField\":\"DestLocation\",\"limit\":2048,\"filterByMapBounds\":true,\"tooltipProperties\":[\"Carrier\",\"DestCityName\",\"DestCountry\",\"OriginCityName\",\"OriginCountry\",\"FlightDelayMin\",\"FlightTimeMin\",\"DistanceMiles\",\"AvgTicketPrice\",\"FlightDelay\"]},\"visible\":true,\"style\":{\"type\":\"VECTOR\",\"properties\":{\"fillColor\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"FlightTimeMin\",\"name\":\"FlightTimeMin\",\"origin\":\"source\"},\"color\":\"Greens\"}},\"lineColor\":{\"type\":\"STATIC\",\"options\":{\"color\":\"#FFFFFF\"}},\"lineWidth\":{\"type\":\"STATIC\",\"options\":{\"size\":1}},\"iconSize\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"DistanceMiles\",\"name\":\"DistanceMiles\",\"origin\":\"source\"},\"minSize\":1,\"maxSize\":32}}}},\"type\":\"VECTOR\"},{\"id\":\"y4jsz\",\"label\":\"Flight Origin Location\",\"minZoom\":0,\"maxZoom\":9,\"alpha\":1,\"sourceDescriptor\":{\"type\":\"ES_GEO_GRID\",\"resolution\":\"COARSE\",\"id\":\"fe893f84-388e-4865-8df4-650748533a77\",\"indexPatternId\":\"d3d7af60-4c81-11e8-b3d7-01146121b73d\",\"geoField\":\"OriginLocation\",\"requestType\":\"point\",\"metrics\":[{\"type\":\"count\"},{\"type\":\"avg\",\"field\":\"FlightTimeMin\"}]},\"visible\":true,\"style\":{\"type\":\"VECTOR\",\"properties\":{\"fillColor\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"Count\",\"name\":\"doc_count\",\"origin\":\"source\"},\"color\":\"Blues\"}},\"lineColor\":{\"type\":\"STATIC\",\"options\":{\"color\":\"#110081\"}},\"lineWidth\":{\"type\":\"STATIC\",\"options\":{\"size\":1}},\"iconSize\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"avg of FlightTimeMin\",\"name\":\"avg_of_FlightTimeMin\",\"origin\":\"source\"},\"minSize\":1,\"maxSize\":32}}}},\"type\":\"VECTOR\"},{\"id\":\"x8xpo\",\"label\":\"Flight Destination Location\",\"minZoom\":0,\"maxZoom\":9,\"alpha\":1,\"sourceDescriptor\":{\"type\":\"ES_GEO_GRID\",\"resolution\":\"COARSE\",\"id\":\"60a7346a-8c5f-4c03-b7d1-e8b36e847551\",\"indexPatternId\":\"d3d7af60-4c81-11e8-b3d7-01146121b73d\",\"geoField\":\"DestLocation\",\"requestType\":\"point\",\"metrics\":[{\"type\":\"count\"},{\"type\":\"avg\",\"field\":\"FlightDelayMin\"}]},\"visible\":true,\"style\":{\"type\":\"VECTOR\",\"properties\":{\"fillColor\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"Count\",\"name\":\"doc_count\",\"origin\":\"source\"},\"color\":\"Reds\"}},\"lineColor\":{\"type\":\"STATIC\",\"options\":{\"color\":\"#af0303\"}},\"lineWidth\":{\"type\":\"STATIC\",\"options\":{\"size\":1}},\"iconSize\":{\"type\":\"DYNAMIC\",\"options\":{\"field\":{\"label\":\"avg of FlightDelayMin\",\"name\":\"avg_of_FlightDelayMin\",\"origin\":\"source\"},\"minSize\":1,\"maxSize\":32}}}},\"type\":\"VECTOR\"}]",
        "uiStateJSON": "{\"isDarkMode\":false}",
        "bounds": { "type": "envelope", "coordinates": [[-139.83779, 56.64828], [-39.33713, 14.04811]] }
      }
    }
  ];
};
