"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const filebeat_apache2_1 = require("./filebeat_apache2");
const filebeat_auditd_1 = require("./filebeat_auditd");
const filebeat_haproxy_1 = require("./filebeat_haproxy");
const filebeat_icinga_1 = require("./filebeat_icinga");
const filebeat_iis_1 = require("./filebeat_iis");
const filebeat_logstash_1 = require("./filebeat_logstash");
const filebeat_mongodb_1 = require("./filebeat_mongodb");
const filebeat_mysql_1 = require("./filebeat_mysql");
const filebeat_nginx_1 = require("./filebeat_nginx");
const filebeat_osquery_1 = require("./filebeat_osquery");
const filebeat_redis_1 = require("./filebeat_redis");
const filebeat_system_1 = require("./filebeat_system");
const filebeat_traefik_1 = require("./filebeat_traefik");
const generic_1 = require("./generic");
const generic_webserver_1 = require("./generic_webserver");
exports.getBuiltinRules = (genericMessageFields) => [
    ...filebeat_apache2_1.filebeatApache2Rules,
    ...filebeat_nginx_1.filebeatNginxRules,
    ...filebeat_redis_1.filebeatRedisRules,
    ...filebeat_system_1.filebeatSystemRules,
    ...filebeat_mysql_1.filebeatMySQLRules,
    ...filebeat_auditd_1.filebeatAuditdRules,
    ...filebeat_haproxy_1.filebeatHaproxyRules,
    ...filebeat_icinga_1.filebeatIcingaRules,
    ...filebeat_iis_1.filebeatIisRules,
    ...filebeat_logstash_1.filebeatLogstashRules,
    ...filebeat_mongodb_1.filebeatMongodbRules,
    ...filebeat_osquery_1.filebeatOsqueryRules,
    ...filebeat_traefik_1.filebeatTraefikRules,
    ...generic_webserver_1.genericWebserverRules,
    ...generic_1.getGenericRules(genericMessageFields),
    {
        when: {
            exists: ['source'],
        },
        format: [
            {
                constant: 'failed to format message from ',
            },
            {
                field: 'source',
            },
        ],
    },
    {
        when: {
            exists: [],
        },
        format: [
            {
                constant: 'failed to find message',
            },
        ],
    },
];
