"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const fp_1 = require("lodash/fp");
const field_filter_processor_1 = require("../common/field_filter_processor");
const group_by_processor_1 = require("../common/group_by_processor");
const nodes_processor_1 = require("../common/nodes_processor");
const query_procssor_1 = require("../common/query_procssor");
const date_histogram_processor_1 = require("./date_histogram_processor");
const metric_buckets_processor_1 = require("./metric_buckets_processor");
exports.createLastNProcessor = (options) => {
    return fp_1.pipe(field_filter_processor_1.fieldsFilterProcessor(options), nodes_processor_1.nodesProcessor(options), query_procssor_1.queryProcessor(options), group_by_processor_1.groupByProcessor(options), date_histogram_processor_1.dateHistogramProcessor(options), metric_buckets_processor_1.metricBucketsProcessor(options));
};
