"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const create_base_path_1 = require("../../lib/create_base_path");
const get_bucket_size_in_seconds_1 = require("../../lib/get_bucket_size_in_seconds");
function getBucketKey(value, interval, offset = 0) {
    return Math.floor((value - offset) / interval) * interval + offset;
}
exports.getBucketKey = getBucketKey;
exports.calculateOffsetInSeconds = (end, interval) => {
    const bucketKey = getBucketKey(end, interval);
    return Math.floor(end - interval - bucketKey);
};
exports.dateHistogramProcessor = (options) => {
    return (doc) => {
        const result = lodash_1.cloneDeep(doc);
        const { timerange, sourceConfiguration, groupBy } = options.nodeOptions;
        const bucketSizeInSeconds = get_bucket_size_in_seconds_1.getBucketSizeInSeconds(timerange.interval);
        const path = create_base_path_1.createBasePath(groupBy).concat('timeseries');
        const bucketOffset = exports.calculateOffsetInSeconds(timerange.from, bucketSizeInSeconds);
        const offset = `${Math.floor(bucketOffset)}s`;
        lodash_1.set(result, path, {
            date_histogram: {
                field: sourceConfiguration.fields.timestamp,
                interval: timerange.interval,
                min_doc_count: 0,
                offset,
                extended_bounds: {
                    min: timerange.from,
                    max: timerange.to,
                },
            },
            aggs: {},
        });
        return result;
    };
};
