"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const adapter_types_1 = require("../../adapter_types");
const constants_1 = require("../../constants");
const nodeTypeToField = (options) => {
    const { fields } = options.nodeOptions.sourceConfiguration;
    switch (options.nodeType) {
        case adapter_types_1.InfraNodeType.pod:
            return fields.pod;
        case adapter_types_1.InfraNodeType.container:
            return fields.container;
        default:
            return fields.host;
    }
};
exports.nodesProcessor = (options) => {
    const { fields } = options.nodeOptions.sourceConfiguration;
    return (doc) => {
        const result = lodash_1.cloneDeep(doc);
        const field = nodeTypeToField(options);
        lodash_1.set(result, 'aggs.waffle.aggs.nodes.terms', {
            field,
            include: {
                num_partitions: options.numberOfPartitions,
                partition: options.partitionId,
            },
            order: { _key: 'asc' },
            size: constants_1.NODE_REQUEST_PARTITION_SIZE * constants_1.NODE_REQUEST_PARTITION_FACTOR,
        });
        lodash_1.set(result, 'aggs.waffle.aggs.nodes.aggs', {
            nodeDetails: {
                top_hits: {
                    size: 1,
                    _source: { includes: [constants_1.NAME_FIELDS[options.nodeType]] },
                    sort: [{ [fields.timestamp]: { order: 'desc' } }],
                },
            },
        });
        return result;
    };
};
