"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
const adapter_types_1 = require("../adapter_types");
const FIELDS = {
    [adapter_types_1.InfraNodeType.host]: 'system.memory.actual.used.pct',
    [adapter_types_1.InfraNodeType.pod]: 'kubernetes.pod.memory.usage.node.pct',
    [adapter_types_1.InfraNodeType.container]: 'docker.memory.usage.pct',
};
exports.memory = (nodeType) => {
    const field = FIELDS[nodeType];
    return { memory: { avg: { field } } };
};
