"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const adapter_types_1 = require("../adapter_types");
const FIELDS = {
    [adapter_types_1.InfraNodeType.host]: 'system.load.5',
    [adapter_types_1.InfraNodeType.pod]: '',
    [adapter_types_1.InfraNodeType.container]: '',
};
exports.load = (nodeType) => {
    const field = FIELDS[nodeType];
    if (field) {
        return { load: { avg: { field } } };
    }
};
