"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const convert_nodes_response_to_groups_1 = require("./convert_nodes_response_to_groups");
const create_node_item_1 = require("./create_node_item");
function processNodes(options, nodes) {
    if (options.groupBy.length === 0) {
        // If there are NO group by options then we need to return a
        // nodes only response
        const nodeResults = nodes.map((node) => {
            return create_node_item_1.createNodeItem(options, node, node);
        });
        return nodeResults;
    }
    // Return a grouped response
    return convert_nodes_response_to_groups_1.convertNodesResponseToGroups(options, nodes);
}
exports.processNodes = processNodes;
