"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const type_guards_1 = require("./type_guards");
function createQuery(options) {
    const { timerange, sourceConfiguration, groupBy, filterQuery } = options;
    const mustClause = [];
    const shouldClause = [];
    const filterClause = [];
    const rangeFilter = {
        range: {
            [sourceConfiguration.fields.timestamp]: {
                format: 'epoch_millis',
                gte: timerange.from,
                lte: timerange.to,
            },
        },
    };
    filterClause.push(rangeFilter);
    if (groupBy) {
        groupBy.forEach((group) => {
            if (type_guards_1.isGroupByTerms(group) && group.field) {
                mustClause.push({
                    exists: {
                        field: group.field,
                    },
                });
            }
            if (type_guards_1.isGroupByFilters(group) && group.filters) {
                group.filters.forEach((groupFilter) => {
                    if (groupFilter != null && groupFilter.query) {
                        shouldClause.push({
                            query_string: {
                                analyze_wildcard: true,
                                query: groupFilter.query,
                            },
                        });
                    }
                });
            }
        });
    }
    if (filterQuery) {
        mustClause.push(filterQuery);
    }
    const query = {
        bool: {
            filter: filterClause,
            must: mustClause,
            should: shouldClause,
        },
    };
    return query;
}
exports.createQuery = createQuery;
