"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = require("lodash");
const types_1 = require("../../../../graphql/types");
const constants_1 = require("../constants");
const create_node_request_body_1 = require("./create_node_request_body");
function createPartitionBodies(totalNodes, nodeType, nodeField, nodeOptions) {
    const { sourceConfiguration } = nodeOptions;
    const bodies = [];
    const numberOfPartitions = Math.ceil(totalNodes / constants_1.NODE_REQUEST_PARTITION_SIZE);
    const indices = nodeOptions.metric.type === types_1.InfraMetricType.logRate
        ? sourceConfiguration.logAlias
        : sourceConfiguration.metricAlias;
    lodash_1.times(numberOfPartitions, (partitionId) => {
        const processorOptions = {
            nodeType,
            nodeField,
            nodeOptions,
            numberOfPartitions,
            partitionId,
        };
        bodies.push({
            index: indices,
        });
        bodies.push(create_node_request_body_1.createNodeRequestBody(processorOptions));
    });
    return bodies;
}
exports.createPartitionBodies = createPartitionBodies;
