"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const create_query_1 = require("./create_query");
async function calculateCardinalityOfNodeField(search, nodeField, options) {
    const { sourceConfiguration } = options;
    const body = {
        aggs: {
            nodeCount: {
                cardinality: { field: nodeField },
            },
        },
        query: create_query_1.createQuery(options),
        size: 0,
    };
    const resp = await search({
        allow_no_indices: true,
        body,
        ignore_unavailable: true,
        index: `${sourceConfiguration.logAlias},${sourceConfiguration.metricAlias}`,
    });
    if (resp.aggregations) {
        return resp.aggregations.nodeCount.value;
    }
    return 0;
}
exports.calculateCardinalityOfNodeField = calculateCardinalityOfNodeField;
