"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const extract_group_by_and_node_from_path_1 = require("../../lib/adapters/nodes/extract_group_by_and_node_from_path");
const usage_collector_1 = require("../../usage/usage_collector");
const serialized_query_1 = require("../../utils/serialized_query");
exports.createNodeResolvers = (libs) => ({
    InfraSource: {
        async map(source, args) {
            return {
                source,
                timerange: args.timerange,
                filterQuery: args.filterQuery,
            };
        },
    },
    InfraResponse: {
        async nodes(mapResponse, args, { req }) {
            const { source, timerange, filterQuery } = mapResponse;
            const { groupBy, nodeType } = extract_group_by_and_node_from_path_1.extractGroupByAndNodeFromPath(args.path);
            usage_collector_1.UsageCollector.countNode(nodeType);
            const options = {
                filterQuery: serialized_query_1.parseFilterQuery(filterQuery),
                nodeType,
                groupBy,
                sourceConfiguration: source.configuration,
                metric: args.metric,
                timerange,
            };
            return await libs.nodes.getNodes(req, options);
        },
    },
});
