"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// A symbol expressing, that the memoized function has never been called
const neverCalled = Symbol();
/**
 * A simple memoize function, that only stores the last returned value
 * and uses the identity of all passed parameters as a cache key.
 */
function memoizeLast(func) {
    let prevCall = neverCalled;
    // We need to use a `function` here for proper this passing.
    // tslint:disable-next-line:only-arrow-functions
    const memoizedFunction = function (...args) {
        if (prevCall !== neverCalled &&
            prevCall.this === this &&
            prevCall.args.length === args.length &&
            prevCall.args.every((arg, index) => arg === args[index])) {
            return prevCall.returnValue;
        }
        prevCall = {
            args,
            this: this,
            returnValue: func.apply(this, args),
        };
        return prevCall.returnValue;
    };
    return memoizedFunction;
}
exports.memoizeLast = memoizeLast;
