"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License;
 * you may not use this file except in compliance with the Elastic License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const reselect_1 = require("reselect");
const remote_graphql_state_1 = require("../../../utils/remote_state/remote_graphql_state");
const summaryGraphlStateSelectors = remote_graphql_state_1.createGraphqlStateSelectors();
exports.selectSummaryBuckets = reselect_1.createSelector(summaryGraphlStateSelectors.selectData, data => (data ? data.buckets : []));
